﻿using System;
using HIPS.HpiiSchemas;
using HIPS.Web.Components.Common;
using HIPS.Web.UI.ViewModels.HpiiSearch;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.Web.UI.Conversion.HpiiSearch
{
    public static class InternationalAddressViewModelExtensions
    {
        public static InternationalAddressViewModel LoadFromInternationalAddress(this InternationalAddressViewModel viewModel, InternationalAddress address)
        {
            viewModel.InternationalAddressLine = address.InternationalAddressLine;
            viewModel.InternationalStateProvince = address.InternationalStateProvince;
            viewModel.InternationalPostcode = address.InternationalPostcode;
            viewModel.CountryCode = address.Country.HasValue ? address.Country.Value.ToString() : String.Empty;

            return viewModel;
        }

        public static InternationalAddress ToInternationalAddress(this InternationalAddressViewModel viewModel)
        {
            if (!viewModel.HasAnyValue())
            {
                return null;
            }

            return new InternationalAddress
            {
                Country = EnumExtensions.TryParse<CountryType>(viewModel.CountryCode),
                InternationalAddressLine = viewModel.InternationalAddressLine,
                InternationalPostcode = viewModel.InternationalPostcode,
                InternationalStateProvince = viewModel.InternationalStateProvince
            };
        }
    }
}